% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.plot.heatmap.r
\name{gl.plot.heatmap}
\alias{gl.plot.heatmap}
\title{Represents a distance matrix as a heatmap}
\usage{
gl.plot.heatmap(D, palette.divergent = gl.colors("div"), verbose = NULL, ...)
}
\arguments{
\item{D}{Name of the distance matrix or class fd object [required].}

\item{palette.divergent}{A divergent palette for the distance values
[default gl.colors("div")].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity]}

\item{...}{Parameters passed to function
\link[gplots]{heatmap.2} (package gplots)}
}
\value{
returns no value (i.e. NULL)
}
\description{
The script plots a heat map to represent the distances in the distance or
dissimilarity matrix. This function is a wrapper for
\link[gplots]{heatmap.2} (package gplots).
}
\examples{
\donttest{
   gl <- testset.gl[1:10,]
   D <- dist(as.matrix(gl),upper=TRUE,diag=TRUE)
   gl.plot.heatmap(D)
   D2 <- gl.dist.pop(possums.gl)
   gl.plot.heatmap(D2)
   D3 <- gl.fixed.diff(testset.gl)
   gl.plot.heatmap(D3)
   }
   if ((requireNamespace("gplots", quietly = TRUE))) {
   D2 <- gl.dist.pop(possums.gl)
   gl.plot.heatmap(D2)
   }
   
}
\seealso{
Other graphics: 
\code{\link{gl.colors}()},
\code{\link{gl.map.interactive}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.select.colors}()},
\code{\link{gl.select.shapes}()},
\code{\link{gl.smearplot}()},
\code{\link{gl.tree.nj}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{graphics}
