% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateWeightsFunctions.R
\name{generateWeightsNormal}
\alias{generateWeightsNormal}
\title{Generates a weight matrix using \link{rnorm}.}
\usage{
generateWeightsNormal(numUnits1, numUnits2,
  weights.mean = getParameter(".weights.mean", 0, ...),
  weights.sd = getParameter(".weights.sd", 0.01, ...), ...)
}
\arguments{
\item{numUnits1}{Number of units in the lower layer.}

\item{numUnits2}{Number of units in the upper layer.}

\item{weights.mean}{\code{mean} parameter to the \link{rnorm} function.}

\item{weights.sd}{\code{sd} parameter to the \link{rnorm} function.}

\item{...}{Additional parameters, used for parameter resolution.}
}
\value{
Weight matrix.
}
\description{
This function is the standard method for generating weights for instances of
\code{\linkS4class{Net}}. It uses \code{\link{rnorm}} to do so.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, generateWeightsFunction = "generateWeightsNormal",
 weights.mean = .1, weights.sd = .05)
}
}
\seealso{
Other weight generation functions: \code{\link{generateWeightsGlorotNormal}},
  \code{\link{generateWeightsGlorotUniform}},
  \code{\link{generateWeightsHeNormal}},
  \code{\link{generateWeightsHeUniform}},
  \code{\link{generateWeightsUniform}}
}

