% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateWeightsFunctions.R
\name{generateWeightsHeNormal}
\alias{generateWeightsHeNormal}
\title{He normal weight initialization}
\usage{
generateWeightsHeNormal(numUnits1, numUnits2,
  weights.mean = getParameter(".weights.mean", 0, ...), ...)
}
\arguments{
\item{numUnits1}{Number of units in the lower layer.}

\item{numUnits2}{Number of units in the upper layer.}

\item{weights.mean}{\code{mean} parameter to the \link{rnorm} function.}

\item{...}{Additional parameters, used for parameter resolution and passed
to \code{\link{generateWeightsNormal}}.}
}
\value{
Weight matrix.
}
\description{
This function is used to generate random weights and biases using
He normal weight initialization as described in
He et al., \url{http://arxiv.org/abs/1502.01852}.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, generateWeightsFunction = "generateWeightsHeNormal",
 weights.mean = .1)
}
}
\references{
He, Kaiming, Xiangyu Zhang, Shaoqing Ren, and Jian Sun (2015).
 "Delving Deep into Rectifiers: Surpassing Human-Level Performance on
 ImageNet Classification". In: CoRR abs/1502.01852.
 URL: http://arxiv.org/abs/1502.01852
}
\seealso{
Other weight generation functions: \code{\link{generateWeightsGlorotNormal}},
  \code{\link{generateWeightsGlorotUniform}},
  \code{\link{generateWeightsHeUniform}},
  \code{\link{generateWeightsNormal}},
  \code{\link{generateWeightsUniform}}
}

