% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbm.Class.R
\docType{class}
\name{RBM-class}
\alias{RBM-class}
\title{Class for restricted Boltzmann machines}
\description{
This class represents a restricted Boltzmann machine.
}
\details{
The RBM can be trained with the implementation of the
contrastive divergence method \code{\link{trainRBM}}. The class inherits the
attributes from the \code{\linkS4class{Net}}.
}
\section{Slots}{

\describe{
\item{\code{weights}}{Object of class \code{"matrix"}. Weight matrix.}

\item{\code{weightsInc}}{Object of class \code{"matrix"}. Matrix of update values for 
the Weight.}

\item{\code{visibleBiases}}{Object of class \code{"array"}. Visible biases array.}

\item{\code{visibleBiasesInc}}{Object of class \code{"array"}. Array of update values
for the visible biases}

\item{\code{visibleUnitStates}}{Object of class \code{"list"}. States of the visible 
units.}

\item{\code{hiddenBiases}}{Object of class \code{"array"}. Hidden biases array.}

\item{\code{hiddenBiasesInc}}{Object of class \code{"array"}. Array of update values 
for the hidden biases.}

\item{\code{hiddenUnitStates}}{Object of class \code{"list"}. States of the hidden 
units.}

\item{\code{posPhaseData}}{Object of class \code{"list"}. Attribute to save the 
positive phase data during the training.}

\item{\code{output}}{Object of class \code{"matrix"}. Output matrix of the RBM.}
}}
\author{
Martin Drees
}
\seealso{
\code{\linkS4class{Net}}, \code{\linkS4class{DArch}}, 
  \code{\link{trainRBM}}

Other darch classes: \code{\link{DArch-class}},
  \code{\link{DataSet-class}}, \code{\link{Net-class}}
}
\keyword{internal}

