% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_activity_frequency_violations.R
\name{detect_activity_frequency_violations}
\alias{detect_activity_frequency_violations}
\title{Check activity frequencies}
\usage{
detect_activity_frequency_violations(activitylog, ..., details,
  filter_condition)
}
\arguments{
\item{activitylog}{The activity log}

\item{...}{Named vectors with name of the activity, and value of the threshold.}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
tbl_df providing an overview of cases for which activities are executed too many times
}
\description{
Function that detects activity frequency anomalies per case
}
\examples{
\donttest{
data("hospital_actlog")
detect_activity_frequency_violations(activitylog = hospital_actlog,
     "Registration" = 1, "Clinical exam" = 1)
}
}
