% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamodel.R
\name{metamodel}
\alias{metamodel}
\title{Linear regression metamodeling}
\usage{
metamodel(
  analysis = c("oneway", "twoway", "multiway"),
  psa,
  params = NULL,
  strategies = NULL,
  outcome = c("eff", "cost", "nhb", "nmb", "nhb_loss", "nmb_loss", "nhb_loss_voi",
    "nmb_loss_voi"),
  wtp = NULL,
  type = c("linear", "gam", "poly"),
  poly.order = 2,
  k = -1
)
}
\arguments{
\item{analysis}{either "oneway" or "twoway"}

\item{psa}{psa object}

\item{params}{string vector with the name(s) of the parameter of interest. Defaults to all.}

\item{strategies}{vector of strategies to consider. The default (NULL) is that all strategies are considered.}

\item{outcome}{either effectiveness ("eff"), cost ("cost"), net health benefit ("nhb"),
net monetary benefit ("nmb"), or the opportunity loss in terms of NHB or
NMB ("nhb_loss" and "nmb_loss", respectively). "nmb_loss_voi" and "nhb_loss_voi" are only
used in internal function calls of metamodel within other VOI functions.}

\item{wtp}{if outcome is NHB or NMB (or the associated loss), must provide the willingness-to-pay threshold}

\item{type}{type of metamodel}

\item{poly.order}{order of polynomial for the linear regression metamodel.
Default: 2}

\item{k}{ the dimension of the basis used to represent the smooth term.
    The default depends on the number of variables that the smooth is a
    function of. \code{k} should not be less than the dimension of the
    null space of the penalty for the term (see
    \code{\link[mgcv]{null.space.dimension}}), but will be reset if
  it is. See \code{\link[mgcv]{choose.k}} for further information.}
}
\value{
A metamodel object, which contains a list of metamodels and other relevant information.
}
\description{
This function estimates a linear regression metamodel for
a given decision-analytic model by using the results of a probabilistic sensitivity analysis (PSA)
}
\details{
The most important option is \code{analysis}, which can be either \code{"oneway"}
or \code{twoway}. If \code{analysis == "oneway"}, a separate metamodel is created
for each combination of the parameters in \code{params} and strategies in \code{strategies}
(by default, this is all strategies and parameters).

If \code{analysis == "twoway"}, \code{params} must be a vector of two parameters, and a metamodel
is created with these two parameters for each strategy in \code{strategies}.
}
\seealso{
\code{\link{predict.metamodel}},
\code{\link{make_psa_obj}},
\code{\link{owsa}},
\code{\link{twsa}}
}
