% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evsi.R
\name{calc_evsi}
\alias{calc_evsi}
\title{Calculate Expected Value of Sample Information (EVSI)}
\usage{
calc_evsi(
  psa,
  wtp,
  params = NULL,
  outcome = c("nhb", "nmb"),
  k = -1,
  n = 100,
  n0 = 10,
  n_by_param = FALSE,
  pop = 1,
  progress = TRUE
)
}
\arguments{
\item{psa}{object of class psa, produced by \code{\link{make_psa_obj}}}

\item{wtp}{willingness-to-pay threshold}

\item{params}{A vector of parameter names to be analyzed in terms of EVPPI.}

\item{outcome}{either net monetary benefit (\code{"nmb"})
or net health benefit (\code{"nhb"})}

\item{k}{basis dimension, if \code{type == "gam"}}

\item{n}{additional sample size}

\item{n0}{initial sample size}

\item{n_by_param}{if \code{TRUE}, each parameter in the metamodel can have a unique
initial and additional sample size. \code{n} and \code{n0} must be numerical
vectors of equal length to \code{params}, with each value corresponding to the
initial and additional sample sizes for each parameter in the metamodel. By default,
\code{n_by_param = FALSE}, and each value of \code{n} and \code{n0} is shared by
each parameter in the model. When \code{n_by_param = FALSE}, \code{n0} must be a single
numeric value, and \code{n} must be a numerical vector of additional sample sizes for
which EVSI is calculated from the metamodel.}

\item{pop}{scalar that corresponds to the total population}

\item{progress}{\code{TRUE} or \code{FALSE} for whether or not function progress
should be displayed in console.}
}
\value{
A list containing 1) a data.frame with WTP thresholds, new prospective sample sizes
 (if \code{n_by_param == FALSE}), and corresponding EVSIs
for the selected parameters and 2) a list of metamodels used to estimate EVSI for each
strategy at each willingness to pay threshold.
}
\description{
Calculate Expected Value of Sample Information (EVSI)
}
