% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{coef.dalmatian}
\alias{coef.dalmatian}
\title{Coefficients function for \code{dalmatian} objects}
\usage{
\method{coef}{dalmatian}(object, summary = NULL, ranef = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{summary}{Posterior summaries computed from the supplied \code{dalmatian} object (optional).}

\item{ranef}{Random effects summary computed from the supplied \code{dalmatian} object (optional).}

\item{...}{Ignored}
}
\value{
List of three lists named mean, dispersion, and joint each containing the posterior means of the coefficients
corresponding to the fixed and random terms of that model component (if present).
}
\description{
coef (dalmatian)
}
\details{
Extracts coefficients for the mean and dispersion components of a
dalmatian model.
}
\references{
Bonner, S., Kim, H., Westneat, D., Mutzel, A.,
Wright, J., and Schofield, M.. (2021). \code{dalmatian}: A Package
for Fitting Double Hierarchical Linear Models in \code{R} via \code{JAGS} and
\code{nimble}. \emph{Journal of Statistical Software}, 100, 10, 1--25.
\doi{10.18637/jss.v100.i10}.
}
\author{
Simon Bonner
}
