% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_clustering.R
\name{wkmeans}
\alias{wkmeans}
\title{Weighted higher-order initialization}
\usage{
wkmeans(Y, r, asymm)
}
\arguments{
\item{Y}{array/matrix, order-3 tensor/matrix observation}

\item{r}{vector, the number of clusters on each mode; see "details"}

\item{asymm}{logic variable, if "TRUE", assume the clustering assignment differs in different modes; if "FALSE", assume all the modes share the same clustering assignment}
}
\value{
a list containing the following:

\code{z0} { a list of vectors recording the estimated clustering assignment }

\code{s0} { a list of vectors recording the index of degenerate entities with random clustering assignment}
}
\description{
Weighted higher-order initialization for multiway spherical clustering under degree-corrected tensor block model.
This function takes the tensor/matrix observation, the number of clusters, and a logic variable indicating the symmetry
as input. Output is the estimated clustering assignment.
}
\details{
\code{r} should be a length 2 vector for matrix and length 3 vector for tensor observation;

all the elements in \code{r} should be integer larger than 1;

matrix case and symmetric case only allow \code{r} with the same number of clusters on each mode;

observations with non-identical dimension on each mode are only applicable with \code{asymm = T}.
}
\examples{

test_data = sim_dTBM(seed = 1, imat = FALSE, asymm = FALSE, p = c(50,50,50), r = c(3,3,3),
                    core_control = "control", s_min = 0.05, s_max = 1,
                    dist = "normal", sigma = 0.5,
                    theta_dist = "pareto", alpha = 4, beta = 3/4)

initialization <- wkmeans(test_data$Y, r = c(3,3,3), asymm = FALSE)

}
