% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_lower_upper_smart}
\alias{get_lower_upper_smart}
\title{Turn default/special upper and lower arguments to vectors}
\usage{
get_lower_upper_smart(drift_dm_obj, lower, upper, labels = TRUE)
}
\arguments{
\item{drift_dm_obj}{an object of type drift_dm}

\item{lower, upper}{either a vector or list (see \link{create_matrix_l_u})}

\item{labels}{optional logical, if \code{TRUE}, then the returned vectors have
the unique parameter labels according to \link{prm_cond_combo_2_labels}.}
}
\value{
a list with two vectors named \code{lower/upper} that describe the search
space. The length and names (if requested) matches with
coef(model, select_unique = TRUE).
}
\description{
The function is used in the depths of the package to get the search space as
a vector, matching with the free parameters of a model.
Only relevant when users use the "default parameters" approach where they
only specify the parameter labels and assume the package figures out
how each parameter relates across conditions (see \link{simulate_data}).
This comes in handy, when freeing a parameter across conditions, while the
search space remains the same (otherwise, a user would always have to adapt
the vectors for lower/upper to match with \link{x2prms_vals})
}
\details{
The function first gets all unique parameters across conditions using
\link{prms_cond_combo}. The unique parameter labels are then forwarded
to \link{create_matrix_l_u}, together with all (!) the conditions in the
model and the \code{upper}/\code{lower} arguments. Subsequently, the created matrices
are wrangled into vectors in accordance with \link{prms_cond_combo}. The
vectors are then passed back.
}
\keyword{internal}
