% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{Y}
\alias{Y}
\title{Observation functions.}
\usage{
Y(g, f = NULL, states = NULL, parameters = NULL, condition = NULL,
  attach.input = TRUE, deriv = TRUE, compile = FALSE, modelname = NULL,
  verbose = FALSE)
}
\arguments{
\item{g}{Named character vector or equation vector defining the observation function}

\item{f}{Named character of equations or object that can be converted to eqnvec or object of class fn.
If f is provided, states and parameters are guessed from f.}

\item{states}{character vector, alternative definition of "states", usually the names of \code{f}. If both,
f and states are provided, the states argument overwrites the states derived from f.}

\item{parameters}{character vector, alternative definition of the "parameters",
usually the symbols contained in "g" and "f" except for \code{states} and the code word \code{time}. If both,
f and parameters are provided, the parameters argument overwrites the parameters derived from f and g.}

\item{condition}{either NULL (generic prediction for any condition) or a character, denoting
the condition for which the function makes a prediction.}

\item{attach.input}{logical, indiating whether the original input should be
returned with the output.}

\item{deriv}{logical, generate function to evaluate derivatives of observables. Necessary for parameter estimation.}

\item{compile}{Logical, compile the function (see \link{funC0})}

\item{modelname}{Character, used if \code{compile = TRUE}, sets a fixed filename for the
C file.}

\item{verbose}{Print compiler output to R command line.}
}
\value{
Object of class \link{obsfn}, i.e.
a function \code{y(..., deriv = TRUE, conditions = NULL)} representing the evaluation of the 
observation function. Arguments \code{out} (model prediction) and \code{pars} (parameter values)
shoudl be passed by the \code{...} argument.
If \code{out} has the attribute  "sensitivities", the result of
\code{y(out, pars)}, will have an attributed "deriv" which reflecs the sensitivities of 
the observation with respect to the parameters.
If \code{pars} is the result of a parameter transformation \code{p(pars)} (see \link{P}), 
the Jacobian 
of the parameter transformation and the sensitivities of the observation function
are multiplied according to the chain rule for differentiation.
}
\description{
Creates an object of type \link{obsfn} that evaluates an observation function
and its derivatives based on the output of a model prediction function, see \link{prdfn}, 
as e.g. produced by \link{Xs}.
}
\examples{
# Define a time grid on which to make a prediction by peace-wise linear function.
# Then define a (generic) prediction function based on thid grid.
times <- 0:5
grid <- data.frame(name = "A", time = times, row.names = paste0("p", times))
x <- Xd(grid)

# Define an observable and an observation function
observables <- eqnvec(Aobs = "s*A")
g <- Y(g = observables, f = NULL, states = "A", parameters = "s")

# Collect parameters and define an overarching parameter transformation
# for two "experimental condtions".
dynpars <- attr(x, "parameters")
obspars <- attr(g, "parameters")
innerpars <- c(dynpars, obspars)

trafo <- structure(innerpars, names = innerpars)
trafo_C1 <- replaceSymbols(innerpars, paste(innerpars, "C1", sep = "_"), trafo)
trafo_C2 <- replaceSymbols(innerpars, paste(innerpars, "C2", sep = "_"), trafo)

p <- NULL
p <- p + P(trafo = trafo_C1, condition = "C1")
p <- p + P(trafo = trafo_C2, condition = "C2")

# Collect outer (overarching) parameters and 
# initialize with random values
outerpars <- attr(p, "parameters")
pars <- structure(runif(length(outerpars), 0, 1), names = outerpars)

# Predict internal/unobserved states
out1 <- (x*p)(times, pars)
plot(out1)

# Predict observed states in addition to unobserved
out2 <- (g*x*p)(times, pars)
plot(out2)
}
