% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/toolsDaniel.R
\name{datapointL2}
\alias{datapointL2}
\title{L2 objective function for validation data point}
\usage{
datapointL2(p, prediction, mu, time = 0, sigma = 1, fixed = NULL)
}
\arguments{
\item{p}{Namec numeric, the parameter values}

\item{prediction}{Matrix with first column "time" and one column per predicted state. Can have
an attribute \code{deriv}, the matrix of sensitivities. If present, derivatives of the objective
function with respect to the parameters are returned.}

\item{mu}{Named character of length one. Has the structure \code{mu = c(parname = statename)}, where
\code{statename} is one of the column names of \code{prediction} and \code{parname} is one of the
names of \code{p}, allowing to treat the validation data point as a parameter.}

\item{time}{Numeric of length one. An existing time point in \code{prediction}.}

\item{sigma}{Numeric of length one. The uncertainty assumed for the validation data point.}

\item{fixed}{Named numeric with fixed parameter values (contribute to the prior value
but not to gradient and Hessian)}
}
\value{
List of class \code{obj}, i.e. objective value, gradient and Hessian as list.
}
\description{
L2 objective function for validation data point
}
\details{
Computes the constraint value
\deqn{\left(\frac{x(t)-\mu}{\sigma}\right)^2}{(pred-p[names(mu)])^2/sigma^2}
and its derivatives with respect to p.
}
\examples{
\dontrun{
prediction <- matrix(c(0, 1), nrow = 1, dimnames = list(NULL, c("time", "A")))
derivs <- matrix(c(0, 1, 0.1), nrow = 1, dimnames = list(NULL, c("time", "A.A", "A.k1")))
attr(prediction, "deriv") <- derivs
p0 <- c(A = 1, k1 = 2)
mu <- c(newpoint = "A")
timepoint <- 0

datapointL2(p = c(p, newpoint = 2), prediction, mu, timepoint)
datapointL2(p = c(p, newpoint = 1), prediction, mu, timepoint)
datapointL2(p = c(p, newpoint = 0), prediction, mu, timepoint)
}
}
\seealso{
\link{wrss}, \link{constraintL2}
}

