% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generateEquations.R
\name{addReaction}
\alias{addReaction}
\title{Add reaction to reaction table}
\usage{
addReaction(from, to, rate, f = NULL)
}
\arguments{
\item{from}{character with the left hand side of the reaction, e.g. "2*A + B"}

\item{to}{character with the right hand side of the reaction, e.g. "C + 2*D"}

\item{rate}{named character. The rate associated with the reaction. The name is employed as a description
of the reaction.}

\item{f}{equation list, see \link{generateEquations}}
}
\value{
An object of class \code{eqnList}, a named vector with the equations. Contains attributes "SMatrix"
(the stoichiometric matrix), "species" (the state names), "rates" (the rate expressions) and "description".
}
\description{
Add reaction to reaction table
}
\examples{
\dontrun{
f <- addReaction("2*A+B", "C + 2*D", "k1*B*A^2", NULL)
f <- addReaction("C + A", "B + A", "k2*C*A", f)
}
}

