% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_pie}
\alias{po_pie}
\title{Pie}
\usage{
po_pie(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot a pie
}
\examples{
# library(dplyr)
# dout <- pokemon \%>\%
#  group_by(type_1, color_1) \%>\%
#  count()

dout <- data.frame(
  type_1 = c(
    "bug", "dragon", "electric", "fairy", "fighting",
    "fire", "ghost", "grass", "ground", "ice",
    "normal", "poison", "psychic", "rock", "water"
  ),
  color_1 = c(
    "#A8B820", "#7038F8", "#F8D030", "#EE99AC", "#C03028",
    "#F08030", "#705898", "#78C850", "#E0C068", "#98D8D8",
    "#A8A878", "#A040A0", "#F85888", "#B8A038", "#6890F0"
  ),
  n = c(
    12, 3, 9, 2, 7,
    12, 3, 12, 8, 2,
    22, 14, 8, 9, 28
  )
)

d3po(dout) \%>\%
  po_pie(daes(size = n, group = type_1, color = color_1)) \%>\%
  po_title("Share of Pokemon by main type")
}
