% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_margin.R
\name{fit_angle}
\alias{fit_angle}
\title{Fit a Circular Univariate Distribution}
\usage{
fit_angle(
  theta,
  parametric = c("vonmises", "wrappedcauchy", "vonmisesmix", FALSE),
  bandwidth = NULL,
  mu = NULL,
  ncomp = 2
)
}
\arguments{
\item{theta}{\link[base]{numeric} \link[base]{vector} of angles in \eqn{[-\pi, \pi)}.}

\item{parametric}{either a \link[base]{character} string describing what distribution
should be fitted (\code{"vonmises"}, \code{"wrappedcauchy"}, or
\code{"vonmisesmix"}), or the \link[base]{logical} \code{FALSE} if a non-parametric
estimation (kernel density) should be made.}

\item{bandwidth}{If \code{parametric = FALSE}, the numeric value of the kernel density bandwidth.
Default is \code{cylcop::\link{opt_circ_bw}(theta, "nrd")}.}

\item{mu}{(optional) \link[base]{numeric} \link[base]{vector}, fixed mean direction(s) of the
parametric distribution.}

\item{ncomp}{\link[base]{integer}, number of components of the mixed von Mises distribution.
Only has an effect if \code{parametric="vonmisesmix"}.}
}
\value{
If a parametric estimate is made, a \link[base]{list} is returned
 containing the estimated parameters, their
standard errors (if available), the log-likelihood,
the AIC and the name of the distribution.
If a non-parametric estimate is made, the output is a '\code{\link[circular]{density.circular}}' object
obtained with the function \code{circular::\link[circular]{density.circular}()} of the '\pkg{circular}'
package.
}
\description{
This function finds parameter estimates of the marginal circular
distribution (with potentially fixed mean), or gives a kernel density estimate using
a von Mises smoothing kernel.
}
\examples{
set.seed(123)

silent_curr <- cylcop_get_option("silent")
cylcop_set_option(silent = TRUE)

n <- 10 #n (number of samples) is set small for performance.

angles <- rvonmisesmix(n,
  mu = c(0, pi),
  kappa = c(2,1),
  prop = c(0.5, 0.5)
)

bw <- opt_circ_bw(theta = angles,
  method="nrd",
  kappa.est = "trigmoments"
)
dens_non_param <- fit_angle(theta = angles,
  parametric = FALSE,
  bandwidth = bw
)

param_estimate <- fit_angle(theta = angles,
  parametric = "vonmisesmix"
)
param_estimate_fixed_mean <- fit_angle(theta = angles,
  parametric = "vonmisesmix",
  mu = c(0, pi),
  ncomp =2
)

cylcop_set_option(silent = silent_curr)

}
\seealso{
\code{circular::\link[circular]{density.circular}()},
\code{\link{fit_angle}()}, \code{\link{opt_circ_bw}()}.
}
