% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrt.R
\name{cycSqrt}
\alias{cycSqrt}
\title{Square root as a cyclotomic number}
\usage{
cycSqrt(x)
}
\arguments{
\item{x}{an integer, a \strong{gmp} rational number (\code{bigq} object), or
a fraction given as a string (e.g. \code{"5/3"})}
}
\value{
The square root of \code{x} as a cyclotomic number.
}
\description{
Square root of an integer or a rational number as a cyclotomic
  number. This is slow.
}
\examples{
cycSqrt(2)
phi <- (1 + cycSqrt(5)) / 2 # the golden ratio
phi^2 - phi # should be 1
}
