% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ways.R
\name{ways}
\alias{ways}
\title{Download data on 'Ways' with cyclability (quietness) ratings}
\usage{
ways(
  bb,
  pat = Sys.getenv("CYCLESTREETS"),
  base_url = "https://api.cyclestreets.net/v2/mapdata?",
  limit = 400,
  types = "way",
  wayFields =
    "name,ridingSurface,id,cyclableText,quietness,speedMph,speedKmph,pause,color",
  zoom = 16
)
}
\arguments{
\item{bb}{An sf or 'bounding box' like object}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{limit}{Maximum number of features to return}

\item{types}{The type of way to get. Default: "way".}

\item{wayFields}{Which attributes of the ways to return?}

\item{zoom}{Zoom level}
}
\description{
R interface to the CycleStreets.net LTN.
See \href{https://www.cyclestreets.net/api/v2/}{API docs}.
}
\examples{
\dontrun{

u_test = paste0("https://api.cyclestreets.net/v2/mapdata?key=c047ed46f7b50b1x",
  "&limit=400&types=way&wayFields=name,ridingSurface,id,cyclableText,",
  "quietness,speedMph,speedKmph,pause,color&zoom=16&",
  "bbox=-9.160863,38.754642,-9.150128,38.75764")
# ways_test = sf::read_sf(u_test)
bb = "0.101131,52.195807,0.170288,52.209719"
bb = "-9.160863,38.754642,-9.150128,38.75764"
way_data = ways(bb)
plot(way_data)
bb = stplanr::routes_fast_sf
way_data = ways(bb)
plot(way_data)
}
}
