% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris_invasion_nc.R
\name{debris_inc}
\alias{debris_inc}
\title{gates out or assign indicators to debris particle.}
\usage{
debris_inc(flowframe, p1, p2)
}
\arguments{
\item{flowframe}{flowframe with debris, BS4, BS5 and other cells.}

\item{p1}{first flowcytometer channel that can be used to separate debris from the rest, e.g. "RED.B.HLin".}

\item{p2}{second flowcytometer channel that can be used to separate debris from the rest, e.g. "YEL.B.HLin"}
}
\value{
list containing; \itemize{
\item \strong{bs4bs5 - flowframe containing non-debris particles}
\item \strong{deb_pos - position of particles that are debris}
\item \strong{bs4bs5_pos - position of particles that are not debris}
}
}
\description{
The function takes in a flowframe and identifies debris contained in the provided flowframe. It is specially designed for flowframe contaning both debris,
             BS4, BS5 and possibly other invading populations.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and \code{\link[flowDensity]{deGate}} functions in the flowDensity package to
         identify peaks between peaks and identify cut-off points between these peaks. A plot of both channels supplied with horizontal line separating
         debris from other cell populations is also returned.
}
\examples{
\donttest{
flowfile_path <- system.file("extdata", "text.fcs", package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) #FCS file contains only one data object
flowfile_nona <- cyanoFilter::nona(x = flowfile)
flowfile_noneg <- cyanoFilter::noneg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cells_nonmargin <- cellmargin(flow.frame = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
debris_inc(flowframe = flowfile, p1 = "RED.B.HLin", p2 = "YEL.B.HLin")
}

}
\seealso{
\code{\link{debris_nc}}
}
