% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cvxclust_admm}
\alias{cvxclust_admm}
\title{Convex clustering via ADMM}
\usage{
cvxclust_admm(X, Lambda, ix, M1, M2, s1, s2, w, gamma, nu, max_iter = 100,
  type = 2, tol_abs = 1e-05, tol_rel = 1e-04, accelerate = TRUE)
}
\arguments{
\item{X}{The p-by-n data matrix whose columns are to be clustered.}

\item{Lambda}{The p-by-k matrix of Lagrange multipliers.}

\item{ix}{The k-by-2 matrix of index pairs.}

\item{M1}{Index set used to track nonzero weights.}

\item{M2}{Index set used to track nonzero weights.}

\item{s1}{Index set used to track nonzero weights.}

\item{s2}{Index set used to track nonzero weights.}

\item{w}{A vector of k positive weights.}

\item{gamma}{The regularization parameter controlling the amount of shrinkage.}

\item{nu}{Augmented Lagrangian penalty parameter}

\item{max_iter}{The maximum number of iterations.}

\item{type}{An integer indicating the norm used: 1 = 1-norm, 2 = 2-norm.}

\item{tol_abs}{The convergence tolerance (absolute).}

\item{tol_rel}{The convergence tolerance (relative).}

\item{accelerate}{If \code{TRUE} (the default), acceleration is turned on.}
}
\value{
\code{U} A list of centroid matrices.

\code{V} A list of centroid difference matrices.

\code{Lambda} A list of Lagrange multiplier matrices.

\code{nu} The final step size used.

\code{primal} The primal residuals.

\code{dual} The dual residuals.

\code{tol_primal} The primal residual tolerances.

\code{tol_dual} The dual residual tolerances.

\code{iter} The number of iterations taken.
}
\description{
\code{cvxclust_admm} performs convex clustering via ADMM. This is an R wrapper function around C code.
Dimensions of various arguments are as follows:
\itemize{
\item{n is the number of data points}
\item{p is the number of features}
\item{k is the number non-zero weights.}
}
Note that the indices matrices 'M1', 'M2', and 'ix' take on values starting at 0 to match the indexing conventions of C.
}
\examples{
## Create random problems
p <- 10
n <- 20
seed <- 12345
nProbs <- 10
errors <- double(nProbs)
for (i in 1:nProbs) {
  seed <- seed + sample(1:1e2,1)
  rnd_problem <- create_clustering_problem(p,n,seed=seed,method='admm')
  X <- rnd_problem$X
  ix <- rnd_problem$ix
  M1 <- rnd_problem$M1
  M2 <- rnd_problem$M2
  s1 <- rnd_problem$s1
  s2 <- rnd_problem$s2
  w  <- rnd_problem$w
  nK <- length(w)
  Lambda <- matrix(rnorm(p*nK),p,nK)
  gamma <- 0.1
  nu <- 1
  max_iter <- 1e6
  tol_abs <- 1e-15
  tol_rel <- 1e-15
  sol_admm_acc <- cvxclust_admm(X,Lambda,ix,M1,M2,s1,s2,w,gamma,nu,max_iter=max_iter,
    tol_abs=tol_abs,tol_rel=tol_rel,accelerate=TRUE)
  sol_admm <- cvxclust_admm(X,Lambda,ix,M1,M2,s1,s2,w,gamma,nu,max_iter=max_iter,
    tol_abs=tol_abs,tol_rel=tol_rel,accelerate=FALSE)
  errors[i] <- norm(as.matrix(sol_admm_acc$U-sol_admm$U),'i')
}
}
\author{
Eric C. Chi, Kenneth Lange
}

