% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_info.R
\name{process_info_binomial}
\alias{process_info_binomial}
\alias{print.process_info_binomial}
\alias{as.character.process_info_binomial}
\alias{process_info_multinomial}
\alias{print.process_info_multinomial}
\alias{as.character.process_info_multinomial}
\alias{process_info_gaussian}
\alias{print.process_info_gaussian}
\alias{as.character.process_info_gaussian}
\title{A set of process information object constructors}
\usage{
process_info_binomial(
  data,
  target_col,
  prediction_cols,
  id_col,
  cat_levels,
  positive,
  cutoff,
  locale = NULL
)

\method{print}{process_info_binomial}(x, ...)

\method{as.character}{process_info_binomial}(x, ...)

process_info_multinomial(
  data,
  target_col,
  prediction_cols,
  pred_class_col,
  id_col,
  cat_levels,
  apply_softmax,
  locale = NULL
)

\method{print}{process_info_multinomial}(x, ...)

\method{as.character}{process_info_multinomial}(x, ...)

process_info_gaussian(data, target_col, prediction_cols, id_col, locale = NULL)

\method{print}{process_info_gaussian}(x, ...)

\method{as.character}{process_info_gaussian}(x, ...)
}
\arguments{
\item{data}{Data frame.}

\item{target_col}{Name of target column.}

\item{prediction_cols}{Names of prediction columns.}

\item{id_col}{Name of ID column.}

\item{cat_levels}{Categorical levels (classes).}

\item{positive}{Name of the positive class.}

\item{cutoff}{The cutoff used to get class predictions from probabilities.}

\item{locale}{The locale when performing the evaluation.
Relevant when any sorting has been performed.}

\item{x}{a process info object used to select a method.}

\item{...}{further arguments passed to or from other methods.}

\item{pred_class_col}{Name of predicted classes column.}

\item{apply_softmax}{Whether softmax has been applied.}
}
\value{
List with relevant information.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Classes for storing process information from prediction evaluations.

Used internally.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
