library(cvms)
context("evaluate_residuals()")

test_that("evaluate_residuals() have expected output", {
  xpectr::set_test_seed(2)

  df <- data.frame("t" = runif(20), "p" = runif(20), "grp" = rep(1:5, 4))

  xpectr::set_test_seed(2)
  # xpectr::gxs_function(fn = evaluate_residuals,
  #                      args_values = list(
  #                        data = list(df, dplyr::group_by(df, .data$grp), NA, 2, tibble::tibble()),
  #                        predictions_col = list("p", "t", "k", NA, 2),
  #                        targets_col = list("t", "p", "k", NA, 2),
  #                        metrics = list(list("all" = TRUE), 4, NA)
  #                      ), indentation = 2)

  ## Testing 'evaluate_residuals'                                             ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing evaluate_residuals(data = df, predictions_co...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11848 <- evaluate_residuals(data = df, predictions_col = "p", targets_col = "t", metrics = list(all = TRUE))
  # Testing class
  expect_equal(
    class(output_11848),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11848[["RMSE"]],
    0.35497,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["MAE"]],
    0.28557,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["NRMSE(RNG)"]],
    0.39379,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["NRMSE(IQR)"]],
    0.63032,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["NRMSE(STD)"]],
    1.16632,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["NRMSE(AVG)"]],
    0.69532,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["RSE"]],
    1.43189,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["RRSE"]],
    1.19661,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["RAE"]],
    1.10497,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["RMSLE"]],
    0.23603,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["MALE"]],
    0.18896,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["MAPE"]],
    0.74249,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["MSE"]],
    0.126,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["TAE"]],
    5.71144,
    tolerance = 1e-4)
  expect_equal(
    output_11848[["TSE"]],
    2.52009,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11848),
    c("RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
      "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE", "MSE", "TAE",
      "TSE"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11848),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11848),
    c("double", "double", "double", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11848),
    c(1L, 15L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11848)),
    character(0),
    fixed = TRUE)

  # Testing evaluate_residuals(data = dplyr::group_by(df...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_17023 <- evaluate_residuals(data = dplyr::group_by(df, .data$grp), predictions_col = "p", targets_col = "t", metrics = list(all = TRUE))
  # Testing class
  expect_equal(
    class(output_17023),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17023[["grp"]],
    c(1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["RMSE"]],
    c(0.44147, 0.17496, 0.27494, 0.43813, 0.37009),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["MAE"]],
    c(0.42508, 0.13528, 0.21217, 0.35566, 0.29967),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["NRMSE(RNG)"]],
    c(0.58196, 0.20651, 0.45248, 1.4606, 0.42595),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["NRMSE(IQR)"]],
    c(1.063, 0.31276, 0.94061, 1.60497, 1.13615),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["NRMSE(STD)"]],
    c(1.28827, 0.4406, 1.01305, 2.6853, 1.02785),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["NRMSE(AVG)"]],
    c(0.69671, 0.34192, 0.45955, 1.38902, 0.7499),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["RSE"]],
    c(2.21285, 0.25884, 1.36835, 9.61444, 1.40864),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["RRSE"]],
    c(1.48757, 0.50876, 1.16977, 3.10072, 1.18686),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["RAE"]],
    c(1.60489, 0.41285, 1.06777, 2.5226, 1.18263),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["RMSLE"]],
    c(0.31106, 0.11261, 0.17139, 0.281, 0.24654),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["MALE"]],
    c(0.29118, 0.08826, 0.13266, 0.22696, 0.20577),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["MAPE"]],
    c(1.0771, 0.26243, 0.33952, 1.36661, 0.66679),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["MSE"]],
    c(0.19489, 0.03061, 0.07559, 0.19196, 0.13697),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["TAE"]],
    c(1.70033, 0.54113, 0.84867, 1.42263, 1.19867),
    tolerance = 1e-4)
  expect_equal(
    output_17023[["TSE"]],
    c(0.77958, 0.12245, 0.30236, 0.76783, 0.54787),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17023),
    c("grp", "RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)",
      "NRMSE(AVG)", "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE",
      "MSE", "TAE", "TSE"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17023),
    c("integer", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17023),
    c("integer", "double", "double", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double",
      "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17023),
    c(5L, 16L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17023)),
    character(0),
    fixed = TRUE)

  # Testing evaluate_residuals(data = NA, predictions_co...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15733 <- xpectr::capture_side_effects(evaluate_residuals(data = NA, predictions_col = "p", targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15733[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15733[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = 2, predictions_col...
  # Changed from baseline: data = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11680 <- xpectr::capture_side_effects(evaluate_residuals(data = 2, predictions_col = "p", targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11680[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11680[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = tibble::tibble(), ...
  # Changed from baseline: data = tibble::tibble()
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19438 <- xpectr::capture_side_effects(evaluate_residuals(data = tibble::tibble(), predictions_col = "p", targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19438[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must have at least 1 rows, but has 0 rows."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19438[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = NULL, predictions_...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19434 <- xpectr::capture_side_effects(evaluate_residuals(data = NULL, predictions_col = "p", targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19434[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19434[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: predictions_col = "t"
  xpectr::set_test_seed(42)
  # Assigning output
  output_11291 <- evaluate_residuals(data = df, predictions_col = "t", targets_col = "t", metrics = list(all = TRUE))
  # Testing class
  expect_equal(
    class(output_11291),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11291[["RMSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["MAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["NRMSE(RNG)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["NRMSE(IQR)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["NRMSE(STD)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["NRMSE(AVG)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["RSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["RRSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["RAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["RMSLE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["MALE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["MAPE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["MSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["TAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_11291[["TSE"]],
    0,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11291),
    c("RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
      "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE", "MSE", "TAE",
      "TSE"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11291),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11291),
    c("double", "double", "double", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11291),
    c(1L, 15L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11291)),
    character(0),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: predictions_col = "k"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18334 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "k", targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18334[['error']]),
    xpectr::strip("Assertion on 'colnames(data)' failed: Must include the elements {k,t}."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18334[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: predictions_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14680 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = NA, targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14680[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'predictions_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14680[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: predictions_col = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15499 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = 2, targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15499[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'predictions_col': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15499[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: predictions_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15526 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = NULL, targets_col = "t", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15526[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'predictions_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15526[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: targets_col = "k"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12388 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = "k", metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12388[['error']]),
    xpectr::strip("Assertion on 'colnames(data)' failed: Must include the elements {p,k}."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12388[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: targets_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17605 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = NA, metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17605[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'targets_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17605[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: targets_col = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11808 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = 2, metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11808[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'targets_col': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11808[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: targets_col = "p"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14052 <- evaluate_residuals(data = df, predictions_col = "p", targets_col = "p", metrics = list(all = TRUE))
  # Testing class
  expect_equal(
    class(output_14052),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14052[["RMSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["MAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["NRMSE(RNG)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["NRMSE(IQR)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["NRMSE(STD)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["NRMSE(AVG)"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["RSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["RRSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["RAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["RMSLE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["MALE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["MAPE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["MSE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["TAE"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_14052[["TSE"]],
    0,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14052),
    c("RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
      "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE", "MSE", "TAE",
      "TSE"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14052),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14052),
    c("double", "double", "double", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14052),
    c(1L, 15L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14052)),
    character(0),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: targets_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18535 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = NULL, metrics = list(all = TRUE)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18535[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'targets_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18535[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: metrics = 4
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19763 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = "t", metrics = 4), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19763[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'metrics': Must be of type 'list', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19763[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: metrics = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12258 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = "t", metrics = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12258[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'metrics': Must be of type 'list', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12258[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing evaluate_residuals(data = df, predictions_co...
  # Changed from baseline: metrics = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14448 <- xpectr::capture_side_effects(evaluate_residuals(data = df, predictions_col = "p", targets_col = "t", metrics = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14448[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'metrics': Must be of type 'list', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14448[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'evaluate_residuals'                                    ####
  #



})

test_that("evaluate_residuals() have expected output", {
  xpectr::set_test_seed(1)

  df <- data.frame("t" = runif(20), "p" = runif(20), "grp" = rep(1:5, 4))

  ungrouped_res <- evaluate_residuals(
    data = df,
    targets_col = "t",
    predictions_col = "p",
    metrics = "all"
  )

  expect_equal(
    colnames(ungrouped_res),
    c("RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)", "NRMSE(AVG)",
    "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE", "MSE", "TAE",
    "TSE")
  )
  expect_equal(ungrouped_res$RMSE, 0.4383415, tolerance = 1e-5)
  expect_equal(ungrouped_res$MAE, 0.3493256, tolerance = 1e-5)
  expect_equal(ungrouped_res$`NRMSE(RNG)`, 0.4712743, tolerance = 1e-5)
  expect_equal(ungrouped_res$`NRMSE(IQR)`, 1.028314, tolerance = 1e-5)
  expect_equal(ungrouped_res$`NRMSE(STD)`, 1.532031, tolerance = 1e-5)
  expect_equal(ungrouped_res$`NRMSE(AVG)`, 0.789566, tolerance = 1e-5)
  expect_equal(ungrouped_res$RMSLE, 0.2955423, tolerance = 1e-5)
  expect_equal(ungrouped_res$MALE, 0.2355741, tolerance = 1e-5)
  expect_equal(ungrouped_res$RAE, 1.425217, tolerance = 1e-5)
  expect_equal(ungrouped_res$RSE, 2.470652, tolerance = 1e-5)
  expect_equal(ungrouped_res$RRSE, 1.571831, tolerance = 1e-5)
  expect_equal(ungrouped_res$MAPE, 0.9233602, tolerance = 1e-5)
  expect_equal(ungrouped_res$MSE, 0.1921433, tolerance = 1e-5)
  expect_equal(ungrouped_res$TAE, 6.986512, tolerance = 1e-5)
  expect_equal(ungrouped_res$TSE, 3.842867, tolerance = 1e-5)

  grouped_res <- evaluate_residuals(
    df %>% dplyr::group_by(grp),
    targets_col = "t",
    predictions_col = "p",
    metrics = "all"
  )

  expect_equal(
    colnames(grouped_res),
    c("grp", "RMSE", "MAE", "NRMSE(RNG)", "NRMSE(IQR)", "NRMSE(STD)",
    "NRMSE(AVG)", "RSE", "RRSE", "RAE", "RMSLE", "MALE", "MAPE",
    "MSE", "TAE", "TSE")
  )
  expect_equal(grouped_res$RMSE,
    c(
      0.451565647616432, 0.519060010936869, 0.475013011667194, 0.454888553611741,
      0.234138573611605
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$MAE,
    c(
      0.407086299266666, 0.397724184789695, 0.358668561675586, 0.391197844815906,
      0.191951038548723
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$`NRMSE(RNG)`,
    c(
      0.652160302469174, 0.675755108193839, 1.1335399485195, 0.861249796972752,
      0.327165018103644
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$`NRMSE(IQR)`,
    c(
      1.30041734700364, 1.15052496357359, 3.81745140187305, 1.44042831439479,
      0.386983932227589
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$`NRMSE(STD)`,
    c(
      1.43814486544896, 1.50905226589782, 2.60289783098973, 1.81516488970619,
      0.624379332243931
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$`NRMSE(AVG)`,
               c(0.967171509741637, 0.93906108387384, 0.652360444408903, 0.79060841208794,
               0.517217611295255),
               tolerance = 1e-5
  )
  expect_equal(grouped_res$RMSLE,
    c(
      0.2886413430748, 0.366211402088592, 0.314237354222149, 0.304503365190871,
      0.166835911010467
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$MALE,
    c(
      0.263279042673231, 0.281636667412819, 0.235196273801541, 0.260569609060969,
      0.137188700334378
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$RAE,
    c(
      1.76112392170928, 1.42859014846979, 2.71964745212324, 2.02383072091832,
      0.598062880532025
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$RSE,
    c(
      2.75768087202294, 3.03631832161513, 9.03343615809475, 4.39309810242944,
      0.51979940071117
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$RRSE,
    c(
      1.66062665040127, 1.74250346387464, 3.00556752679003, 2.09597187539085,
      0.720971151094945
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$MAPE,
    c(
      1.19356123357169, 0.979598260014201, 0.432928785595697, 0.665919069119316,
      1.34479362791513
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$MSE,
    c(
      0.203911534107247, 0.269423294953783, 0.225637361253137, 0.206923596206982,
      0.0548208716528769
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$TAE,
    c(
      1.62834519706666, 1.59089673915878, 1.43467424670234, 1.56479137926362,
      0.767804154194891
    ),
    tolerance = 1e-5
  )
  expect_equal(grouped_res$TSE,
    c(
      0.815646136428989, 1.07769317981513, 0.90254944501255, 0.827694384827926,
      0.219283486611508
    ),
    tolerance = 1e-5
  )
})

test_that("call_evaluate_residuals() creates NA results correcly", {
  xpectr::set_test_seed(1)

  df <- data.frame("t" = runif(20), "p" = runif(20), "grp" = rep(1:5, 4))

  na_tibble <- tibble::tibble(
    "grp" = 1:5,
    "RMSE" = NA,
    "MAE" = NA,
    "TSE" = NA,
    "NRMSE(RNG)" = NA,
    "NRMSE(IQR)" = NA
  )

  expect_equal(
    call_evaluate_residuals(
      data = df, targets_col = "t",
      predictions_col = "p",
      metrics = c("RMSE", "MAE", "TSE", "NRMSE(RNG)", "NRMSE(IQR)"),
      return_nas = TRUE
    ),
    na_tibble[1, 2:6]
  )

  expect_equal(
    call_evaluate_residuals(
      data = df %>% dplyr::group_by(grp),
      targets_col = "t",
      predictions_col = "p",
      metrics = c("RMSE", "MAE", "TSE", "NRMSE(RNG)", "NRMSE(IQR)"),
      return_nas = TRUE
    ),
    na_tibble
  )
})
