% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_alpha_sim.R
\name{cusum_alpha_sim}
\alias{cusum_alpha_sim}
\title{Simulate false signal probability alpha given control limit for CUSUM charts}
\usage{
cusum_alpha_sim(failure_probability, n_patients, odds_multiplier,
  n_simulation, limit, seed = NULL)
}
\arguments{
\item{failure_probability}{Double. Baseline failure probability}

\item{n_patients}{Integer. Number of patients in monitoring period /sample size}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Integer. Number of simulation runs}

\item{limit}{Double. Control limit for signalling performance change}

\item{seed}{Integer. Seed for RNG}
}
\value{
Returns False signal probability of specified CUSUM chart.
}
\description{
Simulate false signal probability alpha given control limit for CUSUM charts
}
\examples{

#
# control limit can be obtained with cusum_limit_sim(),
# here it is set to an arbitrary value (2.96)

# simulate false positive probability of CUSUM
cusum_alpha_sim(
  failure_probability = 0.05,
  n_patients = 100,
  odds_multiplier = 2,
  n_simulation = 10000,
  limit = 2.96,
  seed = 2046
)
}
