% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_limit_sim.R
\name{cusum_limit_sim}
\alias{cusum_limit_sim}
\title{Simulate control limit given false signal probability alpha for CUSUM charts}
\usage{
cusum_limit_sim(failure_probability, n_patients, odds_multiplier,
  n_simulation, alpha, seed = NULL)
}
\arguments{
\item{failure_probability}{Accepted failure probability of process}

\item{n_patients}{Sample size}

\item{odds_multiplier}{Odds multiplier for the alternative hypothesis (<1 looks for decreases)}

\item{n_simulation}{Number of simulations}

\item{alpha}{False signal probability}

\item{seed}{An optional seed for simulation}
}
\value{
Returns the CL
}
\description{
Simulate control limit given false signal probability alpha for CUSUM charts
}
\examples{

# simulate control limits for alpha = 0.05
cusum_limit_sim(failure_probability = 0.05,
    n_patients = 100,
    odds_multiplier = 2,
    n_simulation = 1000,
    alpha = 0.05,
    seed = 2046)
}
