% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{phl_adjust_table}
\alias{phl_adjust_table}
\title{Create flextable for layout's placeholder.}
\usage{
phl_adjust_table(x, olay, id, method = c("all", "height"))
}
\arguments{
\item{x}{data.frame.}

\item{olay}{officer layout created using \code{\link{phl_layout}}.}

\item{id}{of placeholder in \code{olay}.}

\item{method}{if 'all' (default) fits both the width and height. If 'height'
fits only height.}
}
\value{
A \code{flextable} object, which should 
fit into the layout's placeholder.

The result should be ready to pass it 
into \code{\link{phl_with_flextable}}.
}
\description{
Create flextable from data.frame and try to fit the result into layout's placeholder.
}
\examples{

lay <- lay_new(matrix(1:4,nc=2),widths=c(3,2),heights=c(2,1))
lay2 <- lay_new(matrix(1:3))
lay3 <- lay_bind_col(lay,lay2, widths=c(3,1))
offLayout <- phl_layout(lay3)

x <- tail(iris, 10)[,c(1,5)]

phl_adjust_table(x, offLayout, 1)
phl_adjust_table(x, offLayout, 2)

}
