% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursory.R
\name{cursory}
\alias{cursory}
\alias{cursory_all}
\alias{cursory_at}
\alias{cursory_if}
\title{Cursory Functions}
\usage{
cursory_all(.tbl, .funs, ..., var.name = "Variable")

cursory_at(.tbl, .vars, .funs, ..., var.name = "Variable")

cursory_if(.tbl, .predicate, .funs, ..., var.name = "Variable")
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a quosure style lambda \code{~ fun(.)} or a list of either form.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy dots} support.}

\item{var.name}{Name of the column with variable names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}
}
\value{
A \link[tibble:tibble]{tibble} with columns from the groups, the \code{var.name}
column, and columns corresponding to each of function from \code{.funs}.
}
\description{
Cursory functions act like the \code{dplyr} \code{summarize_(all|at|if)}
functions with an important difference, they put the variable name
in a column and for each function passed in it puts the value in
it's own column.
\itemize{
\item \code{cursory_all()} is the analog of \code{\link[dplyr:summarize_all]{dplyr::summarize_all()}}
\item \code{cursory_at()} is the analog of \code{\link[dplyr:summarize_at]{dplyr::summarize_at()}}
\item \code{cursory_if()} is the analog of \code{\link[dplyr:summarize_if]{dplyr::summarize_if()}}
}
}
\examples{
library(dplyr)
data(iris)

## basic summary statistics for each variable in a data frame.
cursory_all(group_by(iris, Species), lst(mean, sd))

## summary statistics for only numeric variables.
cursory_if(iris, is.numeric, lst(mean, sd))

## summary statistics for specific variables.
cursory_at(iris, vars(ends_with("Length")), lst(Variance = var))

}
