% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\name{hook}
\alias{hook}
\alias{before}
\alias{after}
\title{Hooks}
\usage{
before(hook)

after(hook)
}
\arguments{
\item{hook}{A function that will be run. The function first argument is context and the scenario name is the second argument.}
}
\description{
Hooks are functions that are run before or after a scenario.
}
\details{
You can define them alongside steps definitions.

If you want to run a hook only before or after a specific scenario, use it's name to execute hook only for this scenario.
}
\examples{
\dontrun{
before(function(context, scenario_name) {
  context$session <- selenider::selenider_session()
})

after(function(context, scenario_name) {
  selenider::close_session(context$session)
})

after(function(context, scenario_name) {
  if (scenario_name == "Playing one round of the game") {
    context$game$close()
  }
})
}
}
