% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-slice.R
\name{slice_head.cubble_df}
\alias{slice_head.cubble_df}
\alias{slice_tail.cubble_df}
\alias{slice_min.cubble_df}
\alias{slice_max.cubble_df}
\alias{slice_sample.cubble_df}
\title{Slicing a cubble}
\usage{
\method{slice_head}{cubble_df}(data, ...)

\method{slice_tail}{cubble_df}(data, ...)

\method{slice_min}{cubble_df}(data, ...)

\method{slice_max}{cubble_df}(data, ...)

\method{slice_sample}{cubble_df}(data, ...)
}
\arguments{
\item{data}{a cubble object to slice}

\item{...}{other arguments passed to the \code{\link[dplyr:slice]{dplyr::slice()}}}
}
\value{
a cubble object
}
\description{
Slicing can be useful when the number of site is too large to be all visualised in a
single plot. The slicing family in cubble wraps around the \code{\link[dplyr:slice]{dplyr::slice()}} family to
allow slicing from top and bottom, based on a variable, or in random.
}
\examples{
# slice the first 50 stations from the top/ bottom
library(dplyr)
climate_aus |> slice_head(n = 50)
climate_aus |> slice_tail(n = 50)

# slice based on the max/ min of a variable

climate_aus |> slice_max(elev, n = 10)
climate_aus |> slice_min(lat, n = 10)

# random sample
climate_aus |> slice_sample(n = 10)
}
