% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_probabilities.R
\encoding{UTF-8}
\name{joint_probabilities}
\alias{joint_probabilities}
\title{Computes the joint probabilities of a categorical time series}
\usage{
joint_probabilities(series, lag = 1, categories)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}
}
\value{
A matrix with the joint probabilities.
}
\description{
\code{joint_probabilities} returns a matrix with the joint
probabilities of a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
matrix \eqn{\widehat{\boldsymbol P}(l) = \big(\widehat{p}_{ij}(l)\big)_{1 \le i, j \le r}},
with \eqn{\widehat{p}_{ij}(l)=\frac{N_{ij}(l)}{T-l}}, where \eqn{N_{ij}(l)} is the number
of pairs \eqn{(\overline{X}_t, \overline{X}_{t-l})=(i,j)} in the realization \eqn{\overline{X}_t}.
}
\examples{
matrix_jp <- joint_probabilities(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the matrix of
# joint probabilities for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
