% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctIndplot.R
\name{ctIndplot}
\alias{ctIndplot}
\title{ctIndplot}
\usage{
ctIndplot(datawide, n.subjects, n.manifest, Tpoints, colourby = "subject",
  vars = "all", opacity = 1, varnames = NULL, xlab = "Time",
  ylab = "Value", start = 0, legendposition = "topright", ...)
}
\arguments{
\item{datawide}{ctsem wide format data}

\item{n.subjects}{Number of subjects to randomly select for plotting.}

\item{n.manifest}{Number of manifest variables in data structure}

\item{Tpoints}{Number of discrete time points per case in data structure}

\item{colourby}{set  plot colours by "subject" or "variable"}

\item{vars}{either 'all' or a numeric vector specifying which manifest variables to plot.}

\item{opacity}{Opacity of plot lines}

\item{varnames}{vector of variable names for legend (defaults to NULL)}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{start}{Measurement occasion to start plotting from - defaults to T0.}

\item{legendposition}{Where to position the legend.}

\item{...}{additional plotting parameters.}
}
\description{
Convenience function to simply plot individual subject trajectories from ctsem wide format data
}
\examples{

data(ctExample1)
ctIndplot(ctExample1,n.subjects=1, n.manifest=2,Tpoints=6, colourby='variable')

}

