% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_trialPopulation.R
\name{f.trialPopulation}
\alias{f.trialPopulation}
\title{Calculate in- and exclusion criteria and age groups}
\usage{
f.trialPopulation(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and new columns:
`.trialPopulationAgeGroup` (factor, "P", "A", "P+A", "E", "A+E", "P+A+E"),
`.trialPopulationInclusion` (string),
`.trialPopulationExclusion` (string).
}
\description{
Trial concept calculated: inclusion and exclusion criteria as well as
age groups that can participate in a trial, based on protocol-related
information. Since CTGOV uses single text field for eligibility criteria,
text extraction is used to separate in- and exclusion criteria.
(See \link{dfMergeVariablesRelevel} with an example for healthy volunteers.)
}
\examples{
# fields needed
f.trialPopulation()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.trialPopulation",
  con = dbc)
trialsDf

}
