% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cthist-package.R
\docType{package}
\name{cthist-package}
\alias{cthist}
\alias{cthist-package}
\title{cthist: Clinical Trial Registry History}
\description{
Retrieves historical versions of clinical trial registry entries from \url{https://ClinicalTrials.gov}. Package functionality and implementation is documented in Carlisle (2022) \doi{10.1371/journal.pone.0270909}.
}
\details{
This package provides 3 functions for mass-downloading
historical clinical trial registry entry data from
ClinicalTrials.gov

clinicaltrials_gov_dates() downloads the dates on which
clinical trial registry entries were updated from
ClinicalTrials.gov

clinicaltrials_gov_version() downloads a specified
historical version of a clinical trial registry entry from
ClinicalTrials.gov

clinicaltrials_gov_download() mass-downloads clinical
trial registry entry versions for one or many trials on
ClinicalTrials.gov
}
\references{
Carlisle, BG. Analysis of clinical trial registry entry
histories using the novel R package cthist. medRxiv, 2022. doi:
10.1101/2022.01.20.22269538
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bgcarlisle/cthist}
  \item Report bugs at \url{https://github.com/bgcarlisle/cthist/issues}
}

}
\author{
\strong{Maintainer}: Benjamin Gregory Carlisle \email{murph@bgcarlisle.com} (\href{https://orcid.org/0000-0001-8975-0649}{ORCID})

}
\keyword{internal}
