% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dens_cor.R
\name{calc_dens_cor}
\alias{calc_dens_cor}
\title{calc_dens_cor.R}
\usage{
calc_dens_cor(x, Zmat, corMat, log = FALSE)
}
\arguments{
\item{x}{2*1 vector of means.}

\item{Zmat}{J*2 matrix of test statistics.}

\item{corMat}{2*2 matrix describing correlation structure of test statistics.}

\item{log}{return logarithm of density}
}
\value{
A J*1 vector of densities for each row of Zmat.
}
\description{
For J*2 matrix of J sets, calculate the density of bivariate normal under fitted c-csmGmm.
}
\examples{
x <- c(0, 0)
Zmat <- cbind(rnorm(10^5), rnorm(10^5))
calc_dens_cor(x, Zmat, corMat = cor(Zmat))

}
