/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.qa.diff.MatchFeature;
import com.vividsolutions.jump.qa.diff.MatchGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MatchCollection {
    private FeatureCollection inputFC;
    private Collection matchFeatures = new ArrayList();
    private Collection matchGeometries = new ArrayList();

    public MatchCollection(FeatureCollection fc, boolean splitIntoComponents) {
        this.inputFC = fc;
        this.init(fc, splitIntoComponents);
    }

    private void init(FeatureCollection fc, boolean splitIntoComponents) {
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature feat = (Feature)i.next();
            MatchFeature matchFeat = new MatchFeature(feat);
            this.matchFeatures.add(matchFeat);
            Geometry geom = feat.getGeometry();
            Collection list = MatchGeometry.splitGeometry(geom, splitIntoComponents);
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Geometry g = (Geometry)j.next();
                MatchGeometry matchGeom = new MatchGeometry(matchFeat, g);
                this.matchGeometries.add(matchGeom);
            }
        }
    }

    public Iterator geometryIterator() {
        return this.matchGeometries.iterator();
    }

    public Iterator iterator() {
        return this.matchFeatures.iterator();
    }

    public int size() {
        return this.matchFeatures.size();
    }

    public int geometrySize() {
        return this.matchGeometries.size();
    }

    public void computeFeatureMatches() {
        Iterator i = this.matchFeatures.iterator();
        while (i.hasNext()) {
            MatchFeature mf = (MatchFeature)i.next();
            mf.setMatched(true);
        }
        Iterator j = this.matchGeometries.iterator();
        while (j.hasNext()) {
            MatchGeometry mg = (MatchGeometry)j.next();
            if (mg.isMatched()) continue;
            mg.getFeature().setMatched(false);
        }
    }

    public void propagateUnmatchedFeatures() {
        Iterator j = this.matchGeometries.iterator();
        while (j.hasNext()) {
            MatchGeometry mgOpposite;
            MatchGeometry mg = (MatchGeometry)j.next();
            if (mg.getFeature().isMatched() || (mgOpposite = mg.getMatch()) == null) continue;
            mgOpposite.getFeature().setMatched(false);
        }
    }

    public FeatureCollection getUnmatchedFeatures() {
        FeatureDataset noMatch = new FeatureDataset(this.inputFC.getFeatureSchema());
        Iterator i = this.matchFeatures.iterator();
        while (i.hasNext()) {
            MatchFeature mf = (MatchFeature)i.next();
            if (mf.isMatched()) continue;
            noMatch.add(mf.getFeature());
        }
        return noMatch;
    }
}

