/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureUpdate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FeatureUpdateRecorder {
    private Map updates = new HashMap();
    private int updateCount = 0;

    public void update(Feature origFeat, Feature newFeat) {
        this.updates.put(origFeat, new FeatureUpdate(origFeat, newFeat));
        ++this.updateCount;
    }

    public int getCount() {
        return this.updateCount;
    }

    public FeatureDataset applyUpdates(FeatureCollection fc) {
        FeatureDataset fd = new FeatureDataset(fc.getFeatureSchema());
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            FeatureUpdate fu = (FeatureUpdate)this.updates.get(f);
            if (fu == null) {
                fd.add(f);
                continue;
            }
            fd.add(fu.getNew());
        }
        return fd;
    }
}

