% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qott.R
\name{csa.bounds}
\alias{csa.bounds}
\title{csa.bounds}
\usage{
csa.bounds(formla, t, tmin1, tmin2, tname, idname, data, delt.seq, y.seq,
  Y0tqteobj, F.y0 = NULL, F.y1 = NULL, h = NULL, method = c("level",
  "rank"), cl = 1)
}
\arguments{
\item{formla}{outcomevar ~ treatmentvar}

\item{t}{the 3rd period}

\item{tmin1}{the 2nd period}

\item{tmin2}{the 1st period}

\item{tname}{the name of the column containing periods}

\item{idname}{the name of the column containing ids}

\item{data}{a panel data frame}

\item{delt.seq}{the possible values to compute bounds on the distribution
of the treatment effect for}

\item{y.seq}{the possible values for y to take}

\item{Y0tqteobj}{a qte object for obtaining the counterfactual distribution
of untreated potential outcomes for the treated group in period t}

\item{F.y0}{(optional) pre-computed distribution of counterfactual untreated outcomes for the treated group}

\item{F.y1}{(optional) pre-computed distribution of treated outcomes for the treated group}

\item{h}{optional bandwidth}

\item{method}{"level" or "rank" determining whether method should
be used conditional on ytmin1 or the rank of ytmin1}

\item{cl}{(optional) number of multi-cores to use}
}
\value{
csaboundsobj
}
\description{
Compute bounds on the distribution and quantile of the
 treatment effect as given in Callaway (2017) under the copula
 stability assumption and when a first step estimator of the counterfactual
 distribution of untreated potential outcomes for the treated group is
 available.
}
\examples{
\dontrun{
data(displacements)
delt.seq <- seq(-4,4,length.out=50)
y.seq <- seq(6.5,13,length.out=50)
cc <- qte::CiC(learn ~ treat,
               t=2011, tmin1=2007, tname="year",
               idname="id", panel=TRUE, data=displacements,
               probs=seq(.05,.95,.01),se=FALSE)
cc$F.treated.tmin2 <- ecdf(subset(displacements, year==2003 & treat==1)$learn)
cc$F.treated.tmin1 <- ecdf(subset(displacements, year==2007 & treat==1)$learn)
cb <- csa.bounds(learn ~ treat, 2011, 2007, 2003, "year", "id",
        displacements, delt.seq, y.seq, cc,
        method="level", cl=1)
cb
ggCSABounds(cb)
}
}
