% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_detect.R
\name{format_detect}
\alias{format_detect}
\alias{format_detect.data.frame}
\alias{format_detect.list}
\title{Detect transaction file exchange and format it}
\usage{
format_detect(data, ...)

\method{format_detect}{data.frame}(data, list.prices = NULL, force = FALSE, ...)

\method{format_detect}{list}(data, list.prices = NULL, force = FALSE, ...)
}
\arguments{
\item{data}{The dataframe}

\item{...}{Used for other methods.}

\item{list.prices}{A \code{list.prices} object from which to fetch coin prices.}

\item{force}{Whether to force recreating \code{list.prices} even though
it already exists (e.g., if you added new coins or new dates).}
}
\value{
A data frame of exchange transactions, formatted for further processing.
}
\description{
Detect the exchange of a given transaction file and format
it with the proper function for later ACB processing.
}
\examples{
format_detect(data_shakepay)
format_detect(data_newton)
format_detect(list(data_shakepay, data_newton))
}
