% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quote.R
\name{get_quote}
\alias{get_quote}
\title{Get the Open, High, Low, Close and Volume data on a cryptocurrency pair}
\usage{
## get OHLC-V
get_quote(
 ticker,
 source   = 'binance',
 futures  = TRUE,
 interval = '1d',
 from     = NULL,
 to       = NULL
)
}
\arguments{
\item{ticker}{An \link{character}-vector of \link{length} 1. See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default. See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{futures}{A \link{logical}-vector of \link{length} 1. \link{TRUE} by default. Returns futures market if \link{TRUE}, spot market otherwise.}

\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default. See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{from}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}, \link{date} or \link{POSIXct} vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An \link{xts}-object containing,
\itemize{
\item open (\link{numeric}): the opening price
\item close (\link{numeric}): the closing price
\item high (\link{numeric}): the highest price
\item low  (\link{numeric}): the lowest price
\item volume  (\link{numeric}): the trading volume
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get a quote on a cryptocurrency pair from the \code{\link[=available_exchanges]{available_exchanges()}} in various \code{\link[=available_intervals]{available_intervals()}} for any actively traded \code{\link[=available_tickers]{available_tickers()}}.
}
\details{
\subsection{On time-zones and dates}{

Values passed to \code{from} or \code{to} must be coercible by \code{\link[=as.Date]{as.Date()}}, or \code{\link[=as.POSIXct]{as.POSIXct()}}, with a format of either \code{"\%Y-\%m-\%d"} or \code{"\%Y-\%m-\%d \%H:\%M:\%S"}. By default
all dates are passed and returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}. If only \code{to} is provided 200 pips up to the specified date
is returned.
}
}
\examples{
\dontrun{
# script: scr_getQuote
# date: 2024-02-29
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Demonstrate the basic
# usage of the get_quote-function
# script start;


  # 1) Load BTC spot
  # from Kucoin with 30 minute
  # intervals
  BTC <- cryptoQuotes::get_quote(
    ticker   = 'BTCUSDT',
    source   = 'binance',
    interval = '30m',
    futures  = FALSE,
    from     = Sys.Date() - 1
  )

  # 2) chart the spot price
  # using the chart
  # function
  cryptoQuotes::chart(
    ticker = BTC,
    main   = cryptoQuotes::kline(),
    indicator = list(
      cryptoQuotes::volume(),
      cryptoQuotes::bollinger_bands()
    )
  )

# script end;
}
}
\seealso{
Other get-function: 
\code{\link{get_fgindex}()},
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_openinterest}()}
}
\author{
Serkan Korkmaz
}
\concept{get-function}
