% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_info.R
\name{exchange_info}
\alias{exchange_info}
\title{Retrieves info (urls,logo,description,tags,platform,date_added,notice,status) on CMC for given exchange slug}
\usage{
exchange_info(exchange_list = NULL, limit = NULL)
}
\arguments{
\item{exchange_list}{string if NULL retrieve all currently active exchanges (\code{exchange_list()}),
or provide list of exchanges in the \code{exchange_list()} format (e.g. current and/or delisted)}

\item{limit}{integer Return the top n records, default is all exchanges}
}
\value{
List of (active and historically existing) exchanges in a tibble:
\item{id}{CMC exchange id (unique identifier)}
\item{name}{Exchange name}
\item{slug}{Exchange URL slug (unique)}
\item{description}{Exchange description according to CMC}
\item{notice}{Exchange notice (markdown formatted) according to CMC}
\item{logo}{CMC url of CC logo}
\item{type}{Type of exchange}
\item{date_launched}{Launch date of this exchange}
\item{is_hidden}{TBD}
\item{is_redistributable}{TBD}
\item{maker_fee}{Exchanges maker fee}
\item{taker_fee}{Exchanges maker fee}
\item{spot_volume_usd}{Current volume in USD according to CMC}
\item{spot_volume_last_updated}{Latest update of spot volume}
\item{status}{timestamp and other status messages}
\item{tags}{Tibble of tags and tag categories}
\item{url}{Tibble of various resource urls. Gives website, blog, fee, twitter.}
\item{countries}{Tibble of countries the exchange is active in}
\item{fiat}{Tibble of fiat currencies the exchange trades in}
}
\description{
This code uses the web api. It retrieves data for all active, delisted and untracked exchanges! It does not require an 'API' key.
}
\examples{
\dontrun{
# return info for the first three exchanges
exchange_info <- exchange_info(limit=3)
}

}
