% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections.R
\name{readMTZ}
\alias{readMTZ}
\title{Load an MTZ file}
\usage{
readMTZ(filename, message = FALSE)
}
\arguments{
\item{filename}{A character string. The path to a valid mtz
file.}

\item{message}{A logical variable. If TRUE the
function prints a message highlighting data
included in the mtz file. Default value is
\code{message=FALSE}.}
}
\value{
A named list of length 3. The first element is
        called "reflections" and is a dataframe with as
        many columns as are included in the mtz file.
        The name of each column of the dataframe coincides
        with the name of the corresponding column in the mtz.
        The second element is called "header" and is a named
        list in which each name correspond to a valid field
        in the mtz header (see details in
        \code{\link{readMTZHeader}}).
        The third element is called
        "batch_header" and is a list with as many elements as
        the number of batches (images) included in the mtz
        file. Each list element is, itself, a named list
        including all the useful variables stored in batch
        headers. If no batch headers are contained in the file
        (merged mtz), the batch_header element is NULL.
}
\description{
Reads mtz files and store both header information and
reflection data records in named lists. A third list is
used, if the mtz file is an unmerged file, for storing batch
headers.
}
\examples{

datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"1dei_phases.mtz")
ltmp <- readMTZ(filename)
print(names(ltmp))
print(class(ltmp$reflections))
str(ltmp$reflections)
print(class(ltmp$header))
print(class(ltmp$batch_header))

refs <- ltmp$reflections
print(colnames(refs))
print(range(refs$H))

}
