% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchy-server.R
\name{setCrunchyAuthorization}
\alias{setCrunchyAuthorization}
\title{Register authorization logic for your Crunchy app}
\usage{
setCrunchyAuthorization(func)
}
\arguments{
\item{func}{A \code{function (input, output, session)} to call
inside \code{\link[=crunchyServer]{crunchyServer()}}}
}
\value{
Invisibly, the server function. This function is called
for the side effect of setting the authorization function globally. The
function should return \code{TRUE} if the current user is authorized.
}
\description{
Call this to set an expression or server function to evaluate to determine
whether the current user is authorized to access your app. Ideally, this is
cheap to execute because it will be called repeatedly.
}
\examples{
setCrunchyAuthorization(function (input, output, session) {
    # Restrict to users who have crunch.io emails
    endsWith(email(shinyUser()()), "@crunch.io")
})
}
