% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-residuals.R
\name{dimension-comparison}
\alias{dimension-comparison}
\alias{compareCols}
\alias{compareRows}
\alias{compareDims}
\title{Column and row comparison}
\usage{
compareCols(cube, ...)

compareRows(cube, ...)

compareDims(cube, dim = c("cols", "rows"), baseline, x)
}
\arguments{
\item{cube}{a cube to calculate the comparison on}

\item{...}{arguments passed from \code{compareRows()} or \code{compareCols()} to
\code{compareDims()} (i.e. \code{baseline} and \code{x})}

\item{dim}{which dimension is being compared (\code{rows} or \code{cols}, only valid
for \code{compareDims()})}

\item{baseline}{a character, the column to use as a baseline to compare \code{x}
against}

\item{x}{a character, the column to compare against the baseline}
}
\value{
the z-score for the column or row given in \code{x}
}
\description{
Comparing a column or row with a baseline column or row. This calculates the
z-score for the cells when comparing \code{x} to the baseline columns
}
