% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/decks.R,
%   R/dimension-transforms.R, R/slides.R
\name{filter}
\alias{filter}
\alias{filter<-}
\alias{weight<-,CrunchDeck,ANY-method}
\alias{filter<-,CrunchDeck-method}
\alias{filters<-,CrunchDeck,ANY-method}
\alias{transforms,CrunchAnalysisSlide-method}
\alias{transforms,AnalysisCatalog-method}
\alias{transforms,Analysis-method}
\alias{transforms<-,CrunchAnalysisSlide,ANY-method}
\alias{transforms<-,AnalysisCatalog,ANY-method}
\alias{transforms<-,Analysis,ANY-method}
\alias{analyses}
\alias{analysis}
\alias{analysis<-}
\alias{query<-}
\alias{cube}
\alias{cubes}
\alias{displaySettings}
\alias{displaySettings<-}
\alias{vizSpecs}
\alias{vizSpecs<-}
\alias{type,CrunchSlide-method}
\alias{analyses,CrunchAnalysisSlide-method}
\alias{analysis,CrunchAnalysisSlide-method}
\alias{analysis<-,CrunchAnalysisSlide,formula-method}
\alias{analysis<-,CrunchAnalysisSlide,Analysis-method}
\alias{analysis<-,CrunchAnalysisSlide,list-method}
\alias{filter,CrunchAnalysisSlide-method}
\alias{filters,CrunchAnalysisSlide-method}
\alias{filters<-,CrunchAnalysisSlide,ANY-method}
\alias{query<-,CrunchAnalysisSlide,ANY-method}
\alias{cubes,CrunchAnalysisSlide-method}
\alias{cube,CrunchAnalysisSlide-method}
\alias{displaySettings,CrunchAnalysisSlide-method}
\alias{displaySettings<-,CrunchAnalysisSlide,ANY-method}
\alias{vizSpecs,CrunchAnalysisSlide-method}
\alias{vizSpecs<-,CrunchAnalysisSlide,ANY-method}
\alias{cubes,AnalysisCatalog-method}
\alias{displaySettings,AnalysisCatalog-method}
\alias{displaySettings<-,AnalysisCatalog,list-method}
\alias{vizSpecs,AnalysisCatalog-method}
\alias{vizSpecs<-,AnalysisCatalog,list-method}
\alias{query<-,Analysis,formula-method}
\alias{formulaToSlideQuery}
\alias{cube,Analysis-method}
\alias{displaySettings,Analysis-method}
\alias{displaySettings<-,Analysis,ANY-method}
\alias{vizSpecs,Analysis-method}
\alias{vizSpecs<-,Analysis,ANY-method}
\alias{filter,Analysis-method}
\alias{filters,Analysis-method}
\alias{filter,ANY-method}
\alias{filter<-,CrunchAnalysisSlide-method}
\alias{filter<-,Analysis-method}
\alias{filters<-,Analysis,CrunchLogicalExpr-method}
\alias{filters<-,Analysis,CrunchFilter-method}
\alias{filters<-,Analysis,NULL-method}
\alias{filters<-,Analysis,list-method}
\alias{slideQueryEnv}
\alias{cubes,CrunchDeck-method}
\alias{weight,CrunchAnalysisSlide-method}
\alias{weight<-,CrunchAnalysisSlide,ANY-method}
\alias{weight,Analysis-method}
\title{Get and set slide analyses}
\usage{
filter(x, ...)

filter(x) <- value

\S4method{weight}{CrunchDeck,ANY}(x) <- value

\S4method{filter}{CrunchDeck}(x) <- value

\S4method{filters}{CrunchDeck,ANY}(x) <- value

\S4method{transforms}{CrunchAnalysisSlide}(x)

\S4method{transforms}{AnalysisCatalog}(x)

\S4method{transforms}{Analysis}(x)

\S4method{transforms}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{transforms}{AnalysisCatalog,ANY}(x) <- value

\S4method{transforms}{Analysis,ANY}(x) <- value

analyses(x)

analysis(x)

analysis(x) <- value

query(x) <- value

cube(x)

cubes(x)

displaySettings(x)

displaySettings(x) <- value

vizSpecs(x)

vizSpecs(x) <- value

\S4method{type}{CrunchSlide}(x)

\S4method{analyses}{CrunchAnalysisSlide}(x)

\S4method{analysis}{CrunchAnalysisSlide}(x)

\S4method{analysis}{CrunchAnalysisSlide,formula}(x) <- value

\S4method{analysis}{CrunchAnalysisSlide,Analysis}(x) <- value

\S4method{analysis}{CrunchAnalysisSlide,list}(x) <- value

\S4method{filter}{CrunchAnalysisSlide}(x, ...)

\S4method{filters}{CrunchAnalysisSlide}(x)

\S4method{filters}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{query}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{cubes}{CrunchAnalysisSlide}(x)

\S4method{cube}{CrunchAnalysisSlide}(x)

\S4method{displaySettings}{CrunchAnalysisSlide}(x)

\S4method{displaySettings}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{vizSpecs}{CrunchAnalysisSlide}(x)

\S4method{vizSpecs}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{cubes}{AnalysisCatalog}(x)

\S4method{displaySettings}{AnalysisCatalog}(x)

\S4method{displaySettings}{AnalysisCatalog,list}(x) <- value

\S4method{vizSpecs}{AnalysisCatalog}(x)

\S4method{vizSpecs}{AnalysisCatalog,list}(x) <- value

\S4method{query}{Analysis,formula}(x) <- value

formulaToSlideQuery(query, dataset)

\S4method{cube}{Analysis}(x)

\S4method{displaySettings}{Analysis}(x)

\S4method{displaySettings}{Analysis,ANY}(x) <- value

\S4method{vizSpecs}{Analysis}(x)

\S4method{vizSpecs}{Analysis,ANY}(x) <- value

\S4method{filter}{Analysis}(x, ...)

\S4method{filters}{Analysis}(x)

\S4method{filter}{ANY}(x, ...)

\S4method{filter}{CrunchAnalysisSlide}(x) <- value

\S4method{filter}{Analysis}(x) <- value

\S4method{filters}{Analysis,CrunchLogicalExpr}(x) <- value

\S4method{filters}{Analysis,CrunchFilter}(x) <- value

\S4method{filters}{Analysis,`NULL`}(x) <- value

\S4method{filters}{Analysis,list}(x) <- value

slideQueryEnv(weight, filter)

\S4method{cubes}{CrunchDeck}(x)

\S4method{weight}{CrunchAnalysisSlide}(x)

\S4method{weight}{CrunchAnalysisSlide,ANY}(x) <- value

\S4method{weight}{Analysis}(x)
}
\arguments{
\item{x}{a \code{CrunchSlide}, \code{AnalysisCatalog}, or \code{Analysis}}

\item{...}{ignored}

\item{value}{for the setter, an object to set it}

\item{query}{For \code{formulaToSlideQuery()}, a formula that specifies the query, as in
\code{newSlide()}. See Details of \code{\link[=crtabs]{crtabs()}} for more information.}

\item{dataset}{For \code{formulaToSlideQuery()}, a \code{CrunchDataset} that the variables in
\code{query} refer to.}

\item{weight}{For \code{slideQueryEnv()} a crunch variable to use as a weight or \code{NULL}
to indicate no weight should be used.}

\item{filter}{for \code{slideQueryEnv()}, a \code{CrunchFilter} or \code{CrunchExpression} to filter
the slide.}
}
\description{
Slides are composed of analyses, which are effectively \code{CrunchCubes} with some
additional metadata. You can get and set a slide's Analysis Catalog with the
\code{analyses} method, and access an individual analysis with \code{analysis}. There
are also helpers to get and set the components of the analysis such as \code{filter()},
\code{weight()}, \code{transforms()}, \code{displaySettings()} and \code{vizSpecs()}. You can also
get the \code{CrunchCube} from an analysis using \code{cube()}.
}
\details{
For more complex objects like \code{displaySettings()}, \code{vizSpecs()} and \code{transforms()},
the \href{https://crunch.io/api/reference/#patch-/datasets/-dataset_id-/decks/-deck_id-/slides/-slide_id-/analyses/-analysis_id-/}{API documentation}
provides more details.

Advanced users of the API can assign a list to  \verb{analysis<-} to specify settings
on the analyses that are not otherwise available in \code{rcrunch}. The helpers
\code{formulaToSlideQuery()} and \code{slideQueryEnv()} help you create objects for the
\code{query} and \code{query_environment}.
}
\examples{
\dontrun{
# Examples of setting analysis details (in general these setters work on
# the slide, analysis catalog and analysis, but for brevity the examples only
# show on the slide)

# Change the filter
filters(slide) <- NULL # to remove a filter
filters(slide) <- filters(ds)[["My filter"]]
filters(slide) <- list( # Can set multiple filter
    filters(ds)[["My filter"]],
    ds$age_grp == "18-35"
)
filters(deck) <- filters(ds)[["My filter"]] # Can set the same filter on a whole deck too

# Change the weight
weight(slide) <- NULL # to remove
weight(slide) <- ds$weight
weight(deck) <- ds$weight # Can set the same weight on a whole deck too

# Change the transforms
transforms(slide) <- list(rows_dimension = makeDimTransform(hide = "Neutral"))

# Change the displaySettings
displaySettings(slide) <- list(vizType = "groupedBarPlot")

# Change the vizSpecs
# viz_specs can get quite long, see
# https://crunch.io/api/reference/#post-/datasets/-dataset_id-/decks/-deck_id-/slides/
vizSpecs(slide) <- viz_specs

# Change the query
#' query(slide) <- ~ cyl + wt
}
}
