% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hide-variables.R,
%   R/private-variables.R
\name{hiddenFolder}
\alias{hiddenFolder}
\alias{privateFolder}
\alias{hide}
\alias{unhide}
\alias{privatize}
\alias{deprivatize}
\alias{hiddenFolder,CrunchDataset-method}
\alias{hiddenFolder,VariableCatalog-method}
\alias{hiddenFolder,VariableFolder-method}
\alias{hide,CrunchVariable-method}
\alias{hide,VariableCatalog-method}
\alias{unhide,CrunchVariable-method}
\alias{unhide,VariableCatalog-method}
\alias{hideVariables}
\alias{hiddenVariables<-}
\alias{unhideVariables}
\alias{hiddenVariables}
\alias{privateFolder,CrunchDataset-method}
\alias{privateFolder,VariableCatalog-method}
\alias{privateFolder,VariableFolder-method}
\alias{privatize,CrunchVariable-method}
\alias{privatize,VariableCatalog-method}
\alias{deprivatize,CrunchVariable-method}
\alias{deprivatize,VariableCatalog-method}
\alias{privatise}
\alias{deprivatise}
\alias{privatizeVariables}
\alias{privatiseVariables}
\alias{privateVariables<-}
\alias{deprivatizeVariables}
\alias{deprivatiseVariables}
\alias{privateVariables}
\title{Hide/Unhide or Privatize/Deprivatize Variables}
\usage{
hiddenFolder(x)

privateFolder(x)

hide(x)

unhide(x)

privatize(x)

deprivatize(x)

\S4method{hiddenFolder}{CrunchDataset}(x)

\S4method{hiddenFolder}{VariableCatalog}(x)

\S4method{hiddenFolder}{VariableFolder}(x)

\S4method{hide}{CrunchVariable}(x)

\S4method{hide}{VariableCatalog}(x)

\S4method{unhide}{CrunchVariable}(x)

\S4method{unhide}{VariableCatalog}(x)

hideVariables(dataset, variables)

hiddenVariables(x) <- value

unhideVariables(dataset, variables)

hiddenVariables(dataset, key = namekey(dataset))

\S4method{privateFolder}{CrunchDataset}(x)

\S4method{privateFolder}{VariableCatalog}(x)

\S4method{privateFolder}{VariableFolder}(x)

\S4method{privatize}{CrunchVariable}(x)

\S4method{privatize}{VariableCatalog}(x)

\S4method{deprivatize}{CrunchVariable}(x)

\S4method{deprivatize}{VariableCatalog}(x)

privatise(x)

deprivatise(x)

privatizeVariables(dataset, variables)

privatiseVariables(dataset, variables)

privateVariables(x) <- value

deprivatizeVariables(dataset, variables)

deprivatiseVariables(dataset, variables)

privateVariables(dataset, key = namekey(dataset))
}
\arguments{
\item{x}{a Variable, VariableCatalog, or dataset to hide/unhide/privatize/deprivatize}

\item{dataset}{A dataset}

\item{variables}{Variables to change status of}

\item{value}{Replacement values for assignment methods.}

\item{key}{(for \code{hiddenVariables()} / \code{privateVariables()} the Variable attribute to
return. Default is "alias", following \code{envOrOption("crunch.namekey.dataset")}.}
}
\description{
Both hidden and private are hidden from most views in crunch by default.
Hidden variables can be accessed by an user, while private variables
(and all variables derived from them) are only accessible
by users granted "editor" access to the dataset and so can be used to secure
personally identifiable information from non-editors of a dataset.
}
\details{
There are several ways to assign variables into these categories
and access them:
\itemize{
\item \code{hideVariables()} / \code{privatizeVariables()} - take a character vector of variable aliases
and makes them hidden/private. (\code{unhideVariables()} / \code{deprivatizeVariables()} put them
back in the main variable catalog).
\item \code{hide()} / \code{privatize()} - take a \code{CrunchVariable} or \code{VariableCatalog} and
make them hidden/private. (\code{unhide()} / \code{deprivatize()} put them back in the main
variable catalog).
\item \code{hiddenFolder()} / \code{privateFolder()} - take a dataset and return a folder that
contains the hidden/private variables. This folder is like other \code{CrunchFolder}s and
so you can use \code{\link[=mkdir]{mkdir()}} to create subfolders and \code{\link[=mv]{mv()}} to move them in/out.
\item \code{hiddenVariables()} / \code{privateVariabiles()} - return a character vector of variables
that are hidden/private. You can assign into the catalog to add variables or
assign to \code{NULL} to remove all of them.
}
}
