% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-datasets.R
\name{compareDatasets}
\alias{compareDatasets}
\title{Compare two datasets to see how they will append}
\usage{
compareDatasets(A, B)
}
\arguments{
\item{A}{CrunchDataset}

\item{B}{CrunchDataset}
}
\value{
An object of class 'compareDatasets', a list of three elements: (1)
'variables', a data.frame of variable metadata joined on alias; (2)
'categories', a list of data.frames of category metadata joined on category
name, one for each variable with categories; and (3) 'subvariables', a
list of data.frames of subvariable metadata joined on alias, one for each
array variable.

Summary output reports on (1) variables that, when matched across datasets
by alias, have different types; (2) variables that have the same name but
don't match on alias; (3) for variables that match and have categories,
any categories that have the same id but don't match on name; (4) for
array variables that match, any subvariables that have the same name but
don't match on alias; and (5) array variables that, after assembling the
union of their subvariables, point to subvariables that belong to other
arrays.
}
\description{
When one dataset is appended to another, variables and subvariables are
matched on their aliases, and then categories for variables that have them
are matched on category name. This function lines up the metadata between
two datasets as the append operation will so that you can inspect how well
the datasets will align before you do the append.
}
\details{
Calling \code{summary} on the return of this function will print an
overview of places where the matching on variable alias and category name
may lead to undesired outcomes, enabling you to alter one or both datasets
to result in better alignment.
}
\examples{
\dontrun{
comp <- compareDataset(ds1, ds2)
summary(comp)
}
}
