% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\docType{methods}
\name{variables}
\alias{variables}
\alias{dataset-variables}
\alias{variables<-}
\alias{allVariables}
\alias{allVariables<-}
\alias{variables,CubeDims-method}
\alias{variables,CrunchCube-method}
\alias{variables,CrunchDataset-method}
\alias{variables<-,CrunchDataset,VariableCatalog-method}
\alias{allVariables,CrunchDataset-method}
\alias{allVariables<-,CrunchDataset,VariableCatalog-method}
\alias{variables,SearchResults-method}
\alias{variables,VariableFolder-method}
\title{Access a catalog of variables}
\usage{
variables(x)

variables(x) <- value

allVariables(x)

allVariables(x) <- value

\S4method{variables}{CubeDims}(x)

\S4method{variables}{CrunchCube}(x)

\S4method{variables}{CrunchDataset}(x)

\S4method{variables}{CrunchDataset,VariableCatalog}(x) <- value

\S4method{allVariables}{CrunchDataset}(x)

\S4method{allVariables}{CrunchDataset,VariableCatalog}(x) <- value

\S4method{variables}{SearchResults}(x)

\S4method{variables}{VariableFolder}(x)
}
\arguments{
\item{x}{a Dataset}

\item{value}{For the setters, a VariableCatalog to assign.}
}
\value{
All methods return a \code{VariableCatalog} except the \code{VariableFolder}
method, which returns a subset of \code{x} containing only variable references.
Assignment functions return \code{x} with the changes made.
}
\description{
Datasets contain collections of variables. For some purposes, such as
editing variables' metadata, it is helpful to access these variable catalogs
more directly. Other objects, such as cubes and folders, also define
\code{variables()} methods that expose variable metadata.
}
\details{
For datasets, \code{variables()} returns only the active variables in the dataset,
while \code{allVariables()} returns all variables, including hidden variables.
\code{allVariables()} is not defined for other objects.
}
