% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_helpers.R
\name{summary.evaluation}
\alias{summary.evaluation}
\title{Summary of an evaluation}
\usage{
\method{summary}{evaluation}(object, include_test_attributes = TRUE, ...)
}
\arguments{
\item{object}{Evaluation object to make summary of}

\item{include_test_attributes}{Logical. Should all attributes of the test be included in the output?}

\item{...}{Extra arguments to \code{summary.evaluation}}
}
\description{
Produces a summary of an evaluation, consisting of the test attributes and the performance measures
}
\examples{
data(iris)
# A classification test
test <- createtest(data = iris, 
                  dependent = "Species",
                  problem = "classification",
                  method = "randomForest",
                  name = "An example classification test",
                  train_index = sample(150, 100)
)
\dontrun{
# Run the test. The result is an object of class "evaluation"
evaluation <- runtest(test) 
summary(results)
}
}

