% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_prepare.R
\name{method_prepare}
\alias{method_prepare}
\alias{method_prepare.default}
\alias{method_prepare.randomForest}
\title{Method-specific data preparation}
\usage{
method_prepare(method, test, ...)

\method{method_prepare}{default}(method, test, ...)

\method{method_prepare}{randomForest}(method, test, ...)
}
\arguments{
\item{method}{The regression or classification method that needs specific data preparation.}

\item{test}{The test being executed, whose \code{data} attribute is a list of the train and holdout data sets, that has already been prepared by \code{\link{prepare_data}}}

\item{...}{Extra arguments to pass on to class methods}
}
\value{
A prepared data.frame

\code{\link[base]{identity}(data)}
}
\description{
Generic function for method-specific data preparation, if any is necessary
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function for method-specific data preparation. There is no default method-specific preparation, returns \code{\link[base]{identity}}.

\item \code{randomForest}: Random Forest specific data preparation. Calls \code{\link{group_levels}} on \code{data}, then relevels the holdout set so it has no levels not found in the training set (using \code{\link{prepare_data}})
}}

