% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsra_import_course.R
\name{crsra_import_course}
\alias{crsra_import_course}
\title{Imports all the .csv files into one list consisting of all
the tables within the course.}
\usage{
crsra_import_course(workdir = ".", add_course_name = FALSE,
  change_pid_column = FALSE, check_problems = TRUE)
}
\arguments{
\item{workdir}{A character string vector indicating the
directory where the unzipped course is stored.}

\item{add_course_name}{Should a column of the course name
be added to all the \code{data.frame}s}

\item{change_pid_column}{Should the \code{partner_user_id}
column be changed to simply say \code{"partner_user_id"}?}

\item{check_problems}{Should problems with reading in the
data be checked?}
}
\description{
Imports all the .csv files into one list consisting of all
the tables within the course.
}
\examples{
zip_file = system.file("extdata", "fake_course_7051862327916.zip",
package = "crsra")
bn = basename(zip_file)
bn = sub("[.]zip$", "", bn)
res = unzip(zip_file, exdir = tempdir(), overwrite = TRUE)
workdir = file.path(tempdir(), bn)
course_tables = crsra_import_course(workdir,
check_problems = FALSE)
}
