% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt.R
\name{as_gt.crosstable}
\alias{as_gt.crosstable}
\alias{as_gt}
\alias{as_gt.default}
\title{Converts a \code{crosstable} object into a formatted \code{gt} table.}
\usage{
\method{as_gt}{crosstable}(
  x,
  show_test_name = TRUE,
  by_header = NULL,
  keep_id = FALSE,
  generic_labels = list(id = ".id", variable = "variable", value = "value", total =
    "Total", label = "label", test = "test", effect = "effect"),
  ...
)

as_gt(x, ...)

\method{as_gt}{default}(x, ...)
}
\arguments{
\item{x}{object to be converted}

\item{show_test_name}{in the \code{test} column, show the test name}

\item{by_header}{a string to override the \code{by} header}

\item{keep_id}{whether to keep the \code{.id} column}

\item{generic_labels}{names of the crosstable default columns}

\item{...}{arguments for custom methods}
}
\value{
a formatted \code{gt} table
}
\description{
Converts a \code{crosstable} object into a formatted \code{gt} table.

Method to convert an object to a \code{gt} table

Default method to convert an object to a \code{gt} table
}
\section{Methods (by class)}{
\itemize{
\item \code{crosstable}: For crosstables

\item \code{default}: default function
}}

\examples{
xx = mtcars2 \%>\% dplyr::select(2:10)
crosstable(xx) \%>\% as_gt
crosstable(xx, by=am) \%>\% as_gt
crosstable(xx, by=cyl, test=TRUE, total=TRUE, effect=TRUE) \%>\% 
   as_gt(keep_id=TRUE, show_test_name=FALSE, by_header="Cylinders")
}
\seealso{
\code{\link[=as_flextable.crosstable]{as_flextable.crosstable()}}

\code{\link[gt:gt]{gt::gt()}}
}
\author{
Dan Chaltiel

Dan Chaltiel

Dan Chaltiel

Dan Chaltiel
}
\concept{as_gt methods}
