% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.crossnma.R
\name{plot.crossnma}
\alias{plot.crossnma}
\title{Trace plot of MCMC output}
\usage{
\method{plot}{crossnma}(x, ...)
}
\arguments{
\item{x}{An object generated by \code{\link{crossnma}}.}

\item{\dots}{Additional arguments (passed on to
\code{\link[coda]{traceplot}})}
}
\value{
No return value (plot function).
}
\description{
Produces a separate plot for each parameter in the JAGS model. Each
plot shows iterations vs sampled values.
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Trace plot of MCMC output
plot(fit)

}
\seealso{
\code{\link{crossnma}}, \code{\link[coda]{traceplot}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}
}
\keyword{hplot}
